from __future__ import generators
import plus
import Arenas
import random
import Hazards
import math
import DSLHaz

class BoxArena(Arenas.SuperArena):
    "Can you battle you way to the conflict zone and still have enough robot left to fight? Use player slots 1 and 4 for Humans, slots 2 and 3 for AI."
    name = "DSL Obstacle Course Arena"
    preview = "DSLObsArena/obsarena_preview.bmp"
    game_types = ['OBSTACLE COURSE']
    extent = (-13, 13, 10, -10)

    def __init__(self):
        Arenas.SuperArena.__init__(self, "Arenas/DSLObsArena/obsarena.gmf")
        #plus.Arena.__init__(self, "")
        plus.setBackColor(0,0,0)

        degrad = 0.01745
        self.AddStaticCamera("Static Cam 1", (13., 12.6, -10.0), (35*degrad, -50*degrad), degrad*65)
        self.AddStaticCamera("Static Cam 2", (0, 28.8, 0), (90*degrad, 180*degrad), degrad*47)
        self.AddStaticCamera("Static Cam 3", (0, 15.8, -18), (40*degrad, 0), degrad*62)
	self.AddStaticCamera("Cheat Cam", (0, 44, 0), (90*degrad,math.pi), 85*degrad)
	self.AddWatchCamera("Watch Cam 1", (-13, 21, 10), (12, 20, 30*degrad, 20*degrad))
	self.AddWatchCamera("Watch Cam 2", (13, 21, -10), (12, 20, 30*degrad, 20*degrad))
	self.AddWatchCamera("Watch Cam 3", (10, 26, 10), (14, 22, 30*degrad, 30*degrad))
	self.AddWatchCamera("Watch Cam 4", (-10, 26, -10), (16, 24, 30*degrad, 40*degrad))
	
        self.players = ()
        self.chargetimer = 0.0
        self.zaptimer = 0.0

        
    def AddShadowReceivers(self):
        self.SetShadowSource(5.897, 19.159, 5.899)
        
        #Main Arena Floor Shadow Triangles
        self.AddShadowTriangle((-10.2877,0.676244,1.83754), (-12.4182,0.676244,12.4283), (-12.4182,0.676244,1.83754))
      
    def HazardsOn(self, on):
	
        self.flame1a = DSLHaz.Flame((-13, .3, 10), (-5, 0, 5), (.2, .4, .2), .4)
        self.AddHazard(self.flame1a)
        self.flame1b = DSLHaz.Flame((-16, .3, 10), (0, 0, 7), (.2, .4, .2), .4)
        self.AddHazard(self.flame1b)
        self.flame1c = DSLHaz.Flame((-19, .3, 10), (5, 0, 5), (.2, .4, .2), .4)
        self.AddHazard(self.flame1c)
        self.flame1d = DSLHaz.Flame((-13, .3, 13), (-7, 0, 0), (.2, .4, .2), .4)
        self.AddHazard(self.flame1d)
        self.flame1e = DSLHaz.Flame((-16, .3, 13), (0, 2.5, 0), (3, .4, 3), .4)
        self.AddHazard(self.flame1e)
        #self.flame1f = DSLHaz.Flame((-19, .3, 13), (7, 0, 0), (.2, .4, .2), .4)
        #self.AddHazard(self.flame1f)
        self.flame1g = DSLHaz.Flame((-13, .3, 16), (-5, 0, -5), (.2, .4, .2), .4)
        self.AddHazard(self.flame1g)
        #self.flame1h = DSLHaz.Flame((-16, .3, 16), (0, 0, -7), (.2, .4, .2), .4)
        #self.AddHazard(self.flame1h)
        self.flame1i = DSLHaz.Flame((-19, .3, 16), (5, 0, -5), (.2, .4, .2), .4)
        self.AddHazard(self.flame1i)       	    
	self.RegisterZone("fz1" , 3)
        self.flame2a = DSLHaz.Flame((13, .3, -10), (5, 0, -5), (.2, .4, .2), .4)
        self.AddHazard(self.flame2a)
        self.flame2b = DSLHaz.Flame((16, .3, -10), (0, 0, -7), (.2, .4, .2), .4)
        self.AddHazard(self.flame2b)
        self.flame2c = DSLHaz.Flame((19, .3, -10), (-5, 0, -5), (.2, .4, .2), .4)
        self.AddHazard(self.flame2c)
        self.flame2d = DSLHaz.Flame((13, .3, -13), (7, 0, 0), (.2, .4, .2), .4)
        self.AddHazard(self.flame2d)
        self.flame2e = DSLHaz.Flame((16, .3, -13), (0, 2.5, 0), (3, .4, 3), .4)
        self.AddHazard(self.flame2e)
        #self.flame2f = DSLHaz.Flame((19, .3, -13), (-7, 0, 0), (.2, .4, .2), .4)
        #self.AddHazard(self.flame2f)
        self.flame2g = DSLHaz.Flame((13, .3, -16), (5, 0, 5), (.2, .4, .2), .4)
        self.AddHazard(self.flame2g)
        #self.flame2h = DSLHaz.Flame((16, .3, -16), (0, 0, 7), (.2, .4, .2), .4)
        #self.AddHazard(self.flame2h)
        self.flame2i = DSLHaz.Flame((19, .3, -16), (-5, 0, 5), (.2, .4, .2), .4)
        self.AddHazard(self.flame2i) 
	self.RegisterZone("fz2" , 4) 
        prism = self.AddPrismatic("arena_collision", "cages", 0, 0, 1, 0, 0, 1)
        self.cage = DSLHaz.Saws(prism, (0.1,0.1,20))
        self.AddHazard(self.cage)
        self.RegisterZone("cagetrigger1", 5)
        self.RegisterZone("cagetrigger2", 6)
	self.SetSubMaterialSound("cages", "metal", 0.0, "Sounds\\low_clank.wav")
	self.AddPrismatic("arena_collision", "dropper1", 0, 0, 1, 0, 0, 1)
	self.AddPrismatic("arena_collision", "dropper2", 0, 0, 1, 0, 0, 1)
	self.SetSubMaterialSound("dropper1", "metal", 1.0, "Sounds\\cannon_ball.wav")
	self.SetSubMaterialSound("dropper2", "metal", 1.0, "Sounds\\cannon_ball.wav")
	self.SetActive("dropper1", False)
	self.SetActive("dropper2", False)
	#lightning
        self.electricity = DSLHaz.Electricity((0, -1.1, 0))
        self.AddHazard(self.electricity)
        self.CreateLightning(0, (-37, -3.2, 17), (37, -3.2, 17))
        self.CreateLightning(1, (37, -3.1, 17), (-37, -3.1, 17))
        self.CreateLightning(2, (-37, -3.0, 17), (37, -3.0, 17))
        self.CreateLightning(3, (-37, -3.2, 17), (-37, -3.2, -17))
        self.CreateLightning(4, (-37, -3.1, -17), (-37, -3.1, 17))
        self.CreateLightning(5, (-37, -3.0, 17), (-37, -3.0, -17))
        self.CreateLightning(6, (-37, -3.2, -17), (37, -3.2, -17))
        self.CreateLightning(7, (37, -3.1, -17), (-37, -3.1, -17))
        self.CreateLightning(8, (-37, -3.0, -17), (37, -3.0, -17))
        self.CreateLightning(9, (37, -3.2, -17), (37, -3.2, 17))
        self.CreateLightning(10, (37, -3.1, 17), (37, -3.1, -17))
        self.CreateLightning(11, (37, -3.0, -17), (37, -3.0, 17))
        self.RegisterZone("zz2", 7)     
        self.RegisterZone("zz1", 8)
        self.RegisterZone("zz3", 9)     
        self.RegisterZone("zz4", 10)
        self.RegisterZone("zz5", 11)     
        self.RegisterZone("zz6", 12)
        self.RegisterZone("zz7", 13)     
        self.RegisterZone("zz8", 14)
        self.RegisterZone("zz9", 15)     
        self.RegisterZone("zz10", 16)
        self.RegisterZone("zz11", 17)
        self.RegisterZone("zz12", 18)
        self.RegisterZone("zz13", 19)
        self.RegisterZone("zz14", 20)
        self.RegisterZone("dropz1", 21)
        self.RegisterZone("dropz2", 22)
        self.RegisterZone("zz15", 23)
        self.RegisterZone("zz16", 24)
        self.RegisterZone("zz17", 25)
        self.RegisterZone("zz18", 26)
        self.RegisterZone("zz19", 27)
        self.RegisterZone("zz20", 28)

        n = 0
        while n < 12:
            self.SetLightningVisible(n, True)
            n += 1

	#deacivate bricks
        i = 10
        while i<66:
            self.SetSubMaterialSound("brick"+str(i), "metal", 1.0, "Sounds\\cinderblock1.wav")
            self.SetActive("brick"+str(i), False)
            #self.SetPinned("brick"+str(i), True)
            i += 1
	#deactivate droput floor panels
        j = 10
        while j<22:
            self.SetActive("Object"+str(j), False)
            j += 1
	#deactivate small balls
	k = 10
	while k<28:
            self.SetSubMaterialSound("smallball"+str(k), "metal", 8.0, "Sounds\\hzd_hammer_thudobs.wav")
	    self.SetActive("smallball"+str(k), False)
	    k += 1
	self.RegisterZone("ballzone01" , 1)
	self.RegisterZone("ballzone02" , 2)
	#pushers
	prism = self.AddPrismatic("arena_collision", "pusher1", -1, 0, 0, 5.5, 0, 0)
        self.pusher1 = DSLHaz.Spikes(prism, 18000000, (-13.6, 2.28, -1.98))
        prism = self.AddPrismatic("arena_collision", "pusher2", 1, 0, 0, 5.5, 0, 0)
        self.pusher2 = DSLHaz.Spikes(prism, 18000000, (13.6, 2.28, -1.98))
        self.AddHazard(self.pusher1)
        self.AddHazard(self.pusher2)

	self.AddPOV(0, (-34, 30), (1,))
	self.AddPOV(1, (-17, 30), (0,2))
	self.AddPOV(2, (-16, 16), (1,3))
	self.AddPOV(3, (-36, 16), (2,4))
	self.AddPOV(4, (-31, -4), (3,5))
	self.AddPOV(5, (-31, -8), (4,6))
	self.AddPOV(6, (-27, -8), (5,7))
	self.AddPOV(7, (-27, -20), (6,8))
	self.AddPOV(8, (-35, -20), (7,9))
	self.AddPOV(9, (-35, -28), (8,10))
	self.AddPOV(10, (-31, -28), (9,11))
	self.AddPOV(11, (-31, -32), (10,12))
	self.AddPOV(12, (-3, -32), (11,13))
	self.AddPOV(13, (1, 1), (12,))
	#walls
        self.AddCollisionLine((-40, 33), (40, 33))
        self.AddCollisionLine((40, 33), (40, -33))
        self.AddCollisionLine((40, -33), (-40, -33))
        self.AddCollisionLine((-40, -33), (-40, 33))
	#innerwalls
        self.AddCollisionLine((-13, 33), (-13, 27))

        self.AddCollisionLine((-40, 28), (-19, 28))
        self.AddCollisionLine(((-19, 28)), (-19, 19))
        self.AddCollisionLine((-19, 19), (-40, 19))
        self.AddCollisionLine((-40, 19), (-40, 28))

        self.AddCollisionLine((-19, -28), (-5, -28))


	return Arenas.SuperArena.HazardsOn(self, on)

    def Activate(self, on):
        if on: self.players = plus.getPlayers()

        i = 1
        while i<13:
            #self.SetSubMaterialSound("brick"+str(i), "metal", 1.0, "Sounds\\cinderblock1.wav")
            self.SetActive("Object"+str(i), False)
            #self.SetPinned("brick"+str(i), False)
            i += 1
        
        Arenas.SuperArena.Activate(self, on)

    def ZoneEvent(self, direction, id, robot, chassis):
        if id == 1:
            self.SetActive("smallball19", True)
            self.SetActive("smallball20", True)
            self.SetActive("smallball21", True)
            self.SetActive("smallball22", True)
            self.SetActive("smallball23", True)
            self.SetActive("smallball24", True)
            self.SetActive("smallball25", True)
            self.SetActive("smallball26", True)
            self.SetActive("smallball27", True)
        if id == 2:
            self.SetActive("smallball10", True)
            self.SetActive("smallball11", True)
            self.SetActive("smallball12", True)
            self.SetActive("smallball13", True)
            self.SetActive("smallball14", True)
            self.SetActive("smallball15", True)
            self.SetActive("smallball16", True)
            self.SetActive("smallball17", True)
            self.SetActive("smallball18", True)
	if ((id == 3) and ((robot == 1) or (robot == 2) or (robot == 3) or (robot == 4))):
	    self.flame1a.ZoneEvent(direction)
	    self.flame1b.ZoneEvent(direction)
	    self.flame1c.ZoneEvent(direction)
	    self.flame1d.ZoneEvent(direction)
	    self.flame1e.ZoneEvent(direction)
	    #self.flame1f.ZoneEvent(direction)
	    self.flame1g.ZoneEvent(direction)
	    #self.flame1h.ZoneEvent(direction)
	    self.flame1i.ZoneEvent(direction)
	if ((id == 4) and ((robot == 1) or (robot == 2) or (robot == 3) or (robot == 4))):
	    self.flame2a.ZoneEvent(direction)
	    self.flame2b.ZoneEvent(direction)
	    self.flame2c.ZoneEvent(direction)
	    self.flame2d.ZoneEvent(direction)
	    self.flame2e.ZoneEvent(direction)
	    #self.flame2f.ZoneEvent(direction)
	    self.flame2g.ZoneEvent(direction)
	    #self.flame2h.ZoneEvent(direction)
	    self.flame2i.ZoneEvent(direction)
        if id == 5:
            # entering trig zone 1
	    #self.SetPinned("cages", False)
            self.cage.ZoneEvent(direction)
        if id == 6:
            # entering trig zone 2
	    #self.SetPinned("cages", False)
            self.cage.ZoneEvent(direction)
        if id == 7:
            self.electricity.ZoneEvent(direction, robot, chassis)
        if id == 8:
            self.electricity.ZoneEvent(direction, robot, chassis)
        if id == 9:
            self.electricity.ZoneEvent(direction, robot, chassis)
        if ((id == 10) or (id == 11) or (id == 12) or (id == 13) or (id == 14) or (id == 15) or (id == 16) or (id == 17) or (id == 18) or (id == 19) or (id == 20) or (id == 23) or (id == 24) or (id == 25) or (id == 26)):
            self.electricity.ZoneEvent(direction, robot, chassis)
	if ((id == 21) and ((robot == 1) or (robot == 2) or (robot == 3) or (robot == 4))):
	    self.SetActive("dropper1", True)
	if ((id == 22) and ((robot == 1) or (robot == 2) or (robot == 3) or (robot == 4))):
	    self.SetActive("dropper2", True)
	if id == 27:
	    self.pusher2.ZoneEvent(direction)
	if id == 28:
	    self.pusher1.ZoneEvent(direction)
        return True

    def Tick(self):
	
	self.flame1a.Tick()
	self.flame1b.Tick()
	self.flame1c.Tick()
	self.flame1d.Tick()
	self.flame1e.Tick()
	#self.flame1f.Tick()
	self.flame1g.Tick()
	#self.flame1h.Tick()
	self.flame1i.Tick()
	self.flame2a.Tick()
	self.flame2b.Tick()
	self.flame2c.Tick()
	self.flame2d.Tick()
	self.flame2e.Tick()
	#self.flame2f.Tick()
	self.flame2g.Tick()
	#self.flame2h.Tick()
	self.flame2i.Tick()
	self.cage.Tick()
        self.electricity.Tick()
	self.pusher1.Tick()
        self.pusher2.Tick()
            
        if self.zaptimer > 0:
            self.zaptimer -= .25
            if self.zaptimer <= 0:
                self.SetAllLightningVisible(False)
                self.ResetLightningPositions()
            
        if self.chargetimer > 0.0:
            self.chargetimer -= .25
            if self.chargetimer <= 0.0:
                self.SetLightningVisible(0, True)
                self.SetLightningVisible(1, True)
                self.SetLightningVisible(2, True)
                self.chargetimer = 0.0
            elif self.chargetimer <= 1.0:
                self.SetLightningVisible(3, True)
                self.SetLightningVisible(4, True)
                self.SetLightningVisible(5, True)
            elif self.chargetimer <= 2.0:
                self.SetLightningVisible(6, True)
                self.SetLightningVisible(7, True)
                self.SetLightningVisible(8, True)
            elif self.chargetimer <= 3.0:
                self.SetLightningVisible(9, True)
                self.SetLightningVisible(10, True)
                self.SetLightningVisible(11, True)

        # check to see if anyone has been "eliminated" by falling off the tabletop
        for each in self.players:
            if plus.getLocation(each)[1] < -2:
                plus.eliminatePlayer(each)

        return Arenas.SuperArena.Tick(self)

    def Charge(self, time, bots):
        self.chargetimer = time
        self.zaptimer = .5
        self.SetAllLightningVisible(False)
        
        n = 0
        for bot, in_range in bots.iteritems():
            if in_range:
                self.SetLightningStartEnd(n, (0, -50, 0), plus.getLocation(bot))
                self.SetLightningStartEnd(n+1, plus.getLocation(bot), (0, -50.1, 0))
                self.SetLightningStartEnd(n+2, (0, -50.2, 0), plus.getLocation(bot))
                self.SetLightningVisible(n, True)
                self.SetLightningVisible(n+1, True)
                self.SetLightningVisible(n+2, True)
                n+=3
            
    def ResetLightningPositions(self):
        self.SetLightningStartEnd(0, (-37, -3.2, 17), (37, -3.2, 17))
        self.SetLightningStartEnd(1, (37, -3.1, 17), (-37, -3.1, 17))
        self.SetLightningStartEnd(2, (-37, -3.0, 17), (37, -3.0, 17))
        self.SetLightningStartEnd(3, (-37, -3.2, 17), (-37, -3.2, -17))
        self.SetLightningStartEnd(4, (-37, -3.1, -17), (-37, -3.1, 17))
        self.SetLightningStartEnd(5, (-37, -3.0, 17), (-37, -1.0, -17))
        self.SetLightningStartEnd(6, (-37, -3.2, -17), (37, -3.2, -17))
        self.SetLightningStartEnd(7, (37, -3.1, -17), (-37, -3.1, -17))
        self.SetLightningStartEnd(8, (-37, -3.0, -17), (37, -3.0, -17))
        self.SetLightningStartEnd(9, (37, -3.2, -17), (37, -3.2, 17))
        self.SetLightningStartEnd(10, (37, -3.1, 17), (37, -3.1, -17))
        self.SetLightningStartEnd(11, (37, -3.0, -17), (37, -3.0, 17))
    
    def SetAllLightningVisible(self, bVisible):
        for n in range(12):
            self.SetLightningVisible(n, bVisible)

        
Arenas.register(BoxArena)
